# CPU Core Binding Tool

## Process Scheduler User Manual

This software is used to bind specified processes to the CCD0 or CCD1 cores of the CPU, designed for multi-CCD machines (e.g., 9900x, 9950x, 9950x3d, etc.).

## Features

- Automatically reads the process list and check interval from the configuration file (`config.txt`)
- Supports background silent running mode
- Automatically detects the number of CPU cores in the system
- Mutex mechanism to prevent multiple instances from running simultaneously

## Latest Updates

### v1.3.0 [2024-03-26]

- Added segmented configuration functionality
  - Supports two configuration sections: [C0] and [C1]
  - Processes in the [C0] section are bound to CCD0 CPU cores
  - Processes in the [C1] section are bound to CCD1 CPU cores
  - After binding, rendering or other heavy-load programs can basically avoid reducing game frame rates

### v1.2.0 [2024-03-18]

- Added a mutex mechanism to prevent multiple instances of the program
  - When attempting to start a second instance, it will prompt "The program is already running" and automatically exit

### v1.1.0 [2024-03-18]

- Added complete hiding of the console window
- Added tool window style, which does not display in the taskbar when hidden
- Optimized console output logic, silent mode produces no output

## Usage Instructions

1. Create a configuration file `config.txt`

```text
  30  # Check interval (seconds)
  chrome.exe
  notepad.exe
```

2. Run the program

```sh
process.exe
```

- Configuration File Placement: Please place the config.txt configuration file in the same directory as this program. Ensure the paths are consistent so that the program can correctly read the configuration information.
- Adding Process List: Add the list of processes to be scheduled in the config.txt file. Each process name should occupy a separate line and must include the .exe suffix. For example:

```ini
notepad.exe
calc.exe
```

- Setting Loop Check Time: The first line of the config.txt configuration file is used to set the loop check time, in seconds. The default value is 30 seconds. If you need to customize the check time, you can directly modify the number in this line. However, please note that the number in the first line must not be deleted, as it may cause the program to run abnormally. For example, if you want to set the loop check time to 60 seconds, the first line should be:

```ini
60
```

## Technical Support

Author: Jia
Email: <root@258tiao.com>

March 27, 2024
