# CPU 核心绑定工具

### 进程调度器使用说明

本软件用于将指定进程绑定到 CPU 的CCD0或CCD1核心，供多CCD机器使用（例如：9900x、9950x、9950x3d等）。  

## 功能特性

- 自动从配置文件 (`config.txt`) 读取进程列表和检查间隔
- 支持后台静默运行模式 
- 自动识别系统 CPU 核心数量
- 互斥锁机制，防止多个实例同时运行

## 最新更新

## 最新更新

### v1.3.0 [2024-03-26]

- 新增分段配置功能
  - 支持 [C0] 和 [C1] 两个配置段落
  - [C0] 段进程绑定到CCD0 CPU 核心
  - [C1] 段进程绑定CCD1 CPU 核心
  - 绑定完成后可以做到渲染或其他重负载程序基本上不降低游戏帧率

### v1.2.0 [2024-03-18]

- 新增互斥锁机制，防止程序多开
  - 当尝试启动第二个实例时，会提示"程序已经在运行中"并自动退出

### v1.1.0 [2024-03-18]

- 新增完全隐藏控制台窗口

- 添加工具窗口样式，隐藏后不在任务栏显示
- 优化控制台输出逻辑，静默模式不产生任何输出

## 使用方法

1. 创建配置文件 config.txt

   ```text
   30  # 检查间隔(秒)
   chrome.exe
   notepad.exe
   ```

2. 运行程序

   ```bash
   process.exe
   ```

- **配置文件放置**：请将`config.txt`配置文件放置于与本程序相同的目录下。确保路径一致，以便程序能够正确读取配置信息。

- **进程列表添加**：在`config.txt`文件中添加需要调度的进程列表。每个进程名独占一行，并且进程名必须包含`.exe`后缀。例如：

```
notepad.exe
calc.exe
```

- **循环检查时间设置**：`config.txt`配置文件的第一行用于设置循环检查时间，单位为秒。默认值为30秒。若您需要自定义检查时间，可直接修改该行数字。但请务必注意，第一行的数字设置不可删除，否则可能导致程序运行异常。例如，若您希望将循环检查时间设置为60秒，则第一行应填写：

```
60
```



## 技术支持

Jia 

email:root@258tiao.com

2024 年 3 月 27日
