# CPU Core Binding Tool

### Process Scheduler Usage Instructions

This software is used to bind specified processes to CPU CCD0 or CCD1 cores for multi-CCD machines (e.g., 9900x, 9950x, 9950x3d, etc.). Added feature to bind only to physical cores, ensuring each process appears in only one section.

## Features

- Automatically reads process list and check interval from configuration file (`config.txt`)
- Supports background silent running mode
- Automatically recognizes system CPU core count
- Mutex mechanism to prevent multiple instances from running simultaneously

## Latest Updates

### v1.6.0 [2025-11-27]

1. Added "custom core list binding by process" feature (configuration section `[custom]`)
2. Supports core list format: `[1-3,4,6,7]` (combination of ranges and discrete values)
3. Custom binding has the highest priority, followed by `C0P0 > C1P0 > P0 > C0 > C1`
4. Added custom mask display in output logs for easy verification
5. CPU cores are counted from 0, consistent with configuration file, e.g.:
    - [1-3,4,6,7] represents cores 1, 2, 3, 4, 6, 7
    - [0,2,4-5] represents cores 0, 2, 4, 5
    - myapp.exe=[1-3,4,6,7]
    - another.exe=[2,4-5]  


### v1.5.0 [2025-06-09]

1. Modified the read_config function to add parsing for [c0p0] and [c1p0] sections
2. Added c0p0_process_names, c1p0_process_names arrays and corresponding counters
3. Calculated physical core masks for first half and second half of cores
4. Modified process checking logic, setting priority: C0P0 > C1P0 > P0 > C0 > C1
5. Added processing logic for C0P0 and C1P0 section processes
These modifications enable the program to support five different binding methods:

- First half cores ([c0])
- Second half cores ([c1])
- All physical cores ([p0])
- Physical cores in first half ([c0p0])
- Physical cores in second half ([c1p0])

### v1.4.0 [2025-04-05]

- Added processing logic for P0 section processes, binding them to physical cores, ensuring each process appears in only one section.

### v1.3.0 [2025-03-26]

- Added segmented configuration feature
  - Supports [C0] and [C1] configuration sections
  - Processes in [C0] section are bound to CCD0 CPU cores
  - Processes in [C1] section are bound to CCD1 CPU cores
  - After binding, rendering or other heavy-load programs basically won't reduce game frame rates

### v1.2.0 [2025-03-18]

- Added mutex mechanism to prevent multiple program instances
  - When trying to start a second instance, it will display "The program is already running" and automatically exit

### v1.1.0 [2025-03-18]

- Added completely hidden console window
- Added tool window style, doesn't show in taskbar when hidden
- Optimized console output logic, no output in silent mode

## Usage

1. Create configuration file config.txt

   ```text
   30  # Check interval (seconds)
   [c0]
   chrome.exe
   [c1]
   game.exe
   [p0]
   7zG.exe
   [c0p0]
   qq.exe
   [c1p0]
   notepad.exe
   [custom]
   myapp.exe=[1-3,4,6,7]
   another.exe=[0,2,4-5]
   ```
2. Run the program (choose any method)

   ```bash
   process.exe
   ```

- **Configuration file placement**: Please place the `config.txt` configuration file in the same directory as this program. Ensure the path is consistent so the program can correctly read configuration information.
- **Adding process list**: Add the list of processes to be scheduled in the `config.txt` file. Each process name occupies a separate line, and the process name must include the `.exe` suffix. For example:

```
notepad.exe
calc.exe
```

- **Loop check time setting**: The first line of the `config.txt` configuration file is used to set the loop check time, in seconds. The default value is 30 seconds. If you need to customize the check time, you can directly modify this line of numbers. However, please note that the number setting on the first line cannot be deleted, otherwise it may cause abnormal program operation. For example, if you want to set the loop check time to 60 seconds, the first line should be filled with:

```
60
```

### Custom Core Binding Instructions (`[custom]`)

- Format: `ProcessName=[CoreList]`
- Core list supports:
  - Range: `a-b` (inclusive)
  - Discrete: `n`
  - Combination: separated by commas, e.g.: `[1-3,4,6,7]`
- Numbering convention:
  - Only supports 0-based index (fixed): `0` represents core 0, `1` represents core 1, and so on
  - If you don't want to use `CPU0`, avoid filling in `0` in the list
- Examples:
  - `app.exe=[0,2,4-5]` binds to cores 0, 2, 4, 5
  - `game.exe=[1-3,6]` binds to cores 1, 2, 3, 6 (excluding 0)

Custom binding has the highest priority; when a process appears in both other sections and `[custom]`, it will be bound according to the `[custom]` mask.

## Technical Support

Jia

email: root@258tiao.com

March 27, 2025