
# CPU 核心绑定工具

### 进程调度器使用说明

本软件用于将指定进程绑定到 CPU 的CCD0或CCD1核心，供多CCD机器使用（例如：9900x、9950x、9950x3d等）。新增仅绑定到仅物理核心功能，确保每个进程只出现在一个段落中。

## 功能特性

- 自动从配置文件 (`config.txt`) 读取进程列表和检查间隔
- 支持后台静默运行模式
- 自动识别系统 CPU 核心数量
- 互斥锁机制，防止多个实例同时运行

## 最新更新

### v1.6.0 [2025-11-27]

1. 新增“按进程自定义核心列表绑定”功能（配置段落 `[custom]`）
2. 支持核心列表格式：`[1-3,4,6,7]`（区间与离散组合）
3. 自定义绑定优先级最高，优先于 `C0P0 > C1P0 > P0 > C0 > C1`
4. 输出日志增加自定义掩码显示，便于核对
5. CPU 核心从0开始计数，与配置文件一致例如：
    - [1-3,4,6,7] 表示核心1、2、3、4、6、7
    - [0,2,4-5] 表示核心0、2、4、5
    - myapp.exe=[1-3,4,6,7]
    - another.exe=[2,4-5]  


### v1.5.0 [2025-06-09]

1. 修改了 read_config 函数，增加了对 [c0p0] 和 [c1p0] 段落的解析
2. 添加了 c0p0_process_names 、 c1p0_process_names 数组和相应的计数器
3. 计算了前半部分物理核心掩码和后半部分物理核心掩码
4. 修改了进程检查逻辑，设置了优先级：C0P0 > C1P0 > P0 > C0 > C1
5. 添加了对 C0P0 和 C1P0 段进程的处理逻辑
这些修改使程序能够支持五种不同的绑定方式：

- 前半部分核心（[c0]）
- 后半部分核心（[c1]）
- 所有物理核心（[p0]）
- 前半部分的物理核心（[c0p0]）
- 后半部分的物理核心（[c1p0]）

### v1.4.0 [2025-04-05]

- 添加了对 P0 段进程的处理逻辑，将该段进程绑定到物理核心，确保每个进程只出现在一个段落中。

### v1.3.0 [2025-03-26]

- 新增分段配置功能
  - 支持 [C0] 和 [C1] 两个配置段落
  - [C0] 段进程绑定到CCD0 CPU 核心
  - [C1] 段进程绑定CCD1 CPU 核心
  - 绑定完成后可以做到渲染或其他重负载程序基本上不降低游戏帧率

### v1.2.0 [2025-03-18]

- 新增互斥锁机制，防止程序多开
  - 当尝试启动第二个实例时，会提示"程序已经在运行中"并自动退出

### v1.1.0 [2025-03-18]

- 新增完全隐藏控制台窗口
- 添加工具窗口样式，隐藏后不在任务栏显示
- 优化控制台输出逻辑，静默模式不产生任何输出

## 使用方法

1. 创建配置文件 config.txt

   ```text
   30  # 检查间隔(秒)
   [c0]
   chrome.exe
   [c1]
   game.exe
   [p0]
   7zG.exe
   [c0p0]
   qq.exe
   [c1p0]
   notepad.exe
   [custom]
   myapp.exe=[1-3,4,6,7]
   another.exe=[0,2,4-5]
   ```
2. 运行程序（任选一种方式）

   ```bash
   process.exe
   ```

- **配置文件放置**：请将 `config.txt`配置文件放置于与本程序相同的目录下。确保路径一致，以便程序能够正确读取配置信息。
- **进程列表添加**：在 `config.txt`文件中添加需要调度的进程列表。每个进程名独占一行，并且进程名必须包含 `.exe`后缀。例如：

```
notepad.exe
calc.exe
```

- **循环检查时间设置**：`config.txt`配置文件的第一行用于设置循环检查时间，单位为秒。默认值为30秒。若您需要自定义检查时间，可直接修改该行数字。但请务必注意，第一行的数字设置不可删除，否则可能导致程序运行异常。例如，若您希望将循环检查时间设置为60秒，则第一行应填写：

```
60
```

### 自定义核心绑定说明（`[custom]`）

- 格式：`进程名=[核心列表]`
- 核心列表支持：
  - 区间：`a-b`（包含端点）
  - 离散：`n`
  - 组合：用逗号分隔，如：`[1-3,4,6,7]`
- 序号约定：
  - 仅支持 0 起始索引（固定）：`0` 表示第 0 号核心，`1` 表示第 1 号核心，依此类推
  - 如果不希望使用 `CPU0`，请在列表中避免填写 `0`
- 示例：
  - `app.exe=[0,2,4-5]` 绑定到核心 0、2、4、5
  - `game.exe=[1-3,6]` 绑定到核心 1、2、3、6（不包含 0）

自定义绑定优先级最高；当进程同时出现在其他段落与 `[custom]` 中时，按 `[custom]` 的掩码绑定。

## 技术支持

Jia

email:root@258tiao.com

2025 年 3 月 27日
